
/*= Instrument bp2304.h Include File =============================================*/
#include <vpptype.h>



/*== defines for serial communication =========================*/
#define NUL      0x00
#define STX      0x02
#define ETX      0x03
#define EOT      0x04
#define ENQ      0x05
#define ACK      0x06
#define CR       0x0D
#define NAK      0x15

#define BP2304_RESET_OFF    	0
#define BP2304_RESET_ON 	    1

#define BP2304_FREQ_16HZ 	    0
#define BP2304_FREQ_50HZ 	    1
#define BP2304_FREQ_60HZ 	    0

#define BP2304_MODE_SINGLE      0
#define BP2304_MODE_REPETITION  1

#define BP2304_AUTO_RANGE       0
#define BP2304_RANGE_200u       1
#define BP2304_RANGE_2m  	    2
#define BP2304_RANGE_20m        3
#define BP2304_RANGE_200m       4
#define BP2304_RANGE_2		    5
#define BP2304_RANGE_20		    6
#define BP2304_RANGE_200	    7
#define BP2304_RANGE_2K		    8
#define BP2304_RANGE_20K		9

#define BP2304_RESOL_LOW		0
#define BP2304_RESOL_MEDIUM  	1
#define BP2304_RESOL_HIGH		2

#define BP2304_CURRENT_UNIPOLAR	0
#define BP2304_CURRENT_BIPOLAR	1

#define BP2304_CURRENT_SMALL	0
#define BP2304_CURRENT_MEDIUM	1
#define BP2304_CURRENT_LARGE	2

#define BP2304_LOADING_OHMIC		0
#define BP2304_LOADING_INDUCTIVE	1


#define BP2304_GROUND_INTERN		0
#define BP2304_GROUND_FLOAT 		1




/*== defines for program=======================================*/
#define bp2304_MAX_INSTR   10
#define bp2304_MAX_CMD     150
#define bp2304_GPIB        0
#define bp2304_SERIAL      1

#define bp2304_EOC                (1<<9)   /* Bit 9 of Operation Status Registers*/
#define bp2304_MEASURING          (1<<4)   /* Bit 4 of Operation Status Registers*/
#define bp2304_RANGING			  (1<<2)   /* Bit 2 of Operation Status Registers*/
#define bp2304_DEVICE_DEP_ERROR   (1<<3)   /* Bit 3 of Standard Event Registers*/
#define bp2304_EXECUATION_ERROR   (1<<4)   /* Bit 4 of Standard Event Registers*/
#define bp2304_MAX_BINN_LIMIT      8       /* SORT:BINN  => 8 Limit's */








/*= GLOBAL FUNCTION DECLARATIONS ==========================================*/
int _VI_FUNC bp2304_init_gpib (int,int,int,char*,int*);
int _VI_FUNC bp2304_init_serial(int ,long,double,int,int,int,char*,int,int *);
int _VI_FUNC bp2304_local_gpib (int);

int _VI_FUNC bp2304_config_meas_sequence(int,int ,int,int,int);
int _VI_FUNC bp2304_config_meas_mode(int,int ,int ,int );
int _VI_FUNC bp2304_config_meas_current(int,int , int ,int );
int _VI_FUNC bp2304_config_meas_grounding(int,int);

int _VI_FUNC bp2304_corr_set_tk(int,int,int );
int _VI_FUNC bp2304_corr_state(int,int ,int ,double);
int _VI_FUNC bp2304_get_temp(int,double* );

int _VI_FUNC bp2304_comp_limit(int ,int ,int ,double,double,double,int);
int _VI_FUNC bp2304_comp_reset(int );
int _VI_FUNC bp2304_get_comp_data(int ,int[]);
int _VI_FUNC bp2304_class_comp_limit(int ,int ,int,double[],double,int);
int _VI_FUNC bp2304_class_comp_reset(int ) ;
int _VI_FUNC bp2304_get_class_comp_data(int ,int[]);

int _VI_FUNC bp2304_cool_state(int ,int);
int _VI_FUNC bp2304_cool_meas_init(int ,int,double);
int _VI_FUNC bp2304_cool_man_Rk(int , double);
int _VI_FUNC bp2304_cool_meas_Rk_start(int );
int _VI_FUNC bp2304_cool_read_RK(int ,double*,char*);
int _VI_FUNC bp2304_cool_meas_Rk_stop(int );
int _VI_FUNC bp2304_cool_meas_t1(int , int ,double);
int _VI_FUNC bp2304_cool_read_t1(int ,double* );
int _VI_FUNC bp2304_cool_meas_t2(int , int ,double);
int _VI_FUNC bp2304_cool_read_t2(int ,double*);
int _VI_FUNC bp2304_cool_removal_load(int );
int _VI_FUNC bp2304_cool_meas_start(int );
int _VI_FUNC bp2304_cool_meas_stop(int );
int _VI_FUNC bp2304_cool_read_meas(int ,double[],double[],char *,int*);

int _VI_FUNC bp2304_disp_mode(int ,int ,int,double,double,double,double,double,double);
int _VI_FUNC bp2304_disp_enable(int ,int);
int _VI_FUNC bp2304_disp_contrast(int ,double);

int _VI_FUNC bp2304_system_output(int ,int,int );
int _VI_FUNC bp2304_system_keyboard(int ,int ,int);
int _VI_FUNC bp2304_system_buzzer(int ,int);

int _VI_FUNC bp2304_meas_start(int );
int _VI_FUNC bp2304_meas_read(int ,double* ,char*);
int _VI_FUNC bp2304_meas_stop(int );
//int _VI_FUNC bp2304_spoll(int instrID,unsigned char* srq);

//int _VI_FUNC bp2304_get_exe_error(int );
//int _VI_FUNC bp2304_read_std_event_reg(int,int* );
//int _VI_FUNC bp2304_read_oper_event_reg(int ,int*) ;
int _VI_FUNC bp2304_system_error(int );


int _VI_FUNC bp2304_send_scpi(int ,char*);
int _VI_FUNC bp2304_receive_scpi(int , char* ,char*);

int _VI_FUNC bp2304_close(int);
